/**  @file bta_rms_frames.c
*
*    @brief This file implements root mean square calculation of (a) channel(s)
*
*    BLT_DISCLAIMER
*
*    @author Michael Koschutnig
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_RMS_FRAMES_H_INCLUDED
#define BTA_RMS_FRAMES_H_INCLUDED


typedef struct BTA_FltRmsFramesInst {
    BTA_ChannelId channelToProcess;
    BTA_ChannelId channelIdResult;
    uint16_t windowLength;
	uint16_t frameCounter;
	BTA_Frame *frameRef;
	BTA_Frame *frameSum;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltRmsFramesInst;


BTA_Status BFLTrmsFramesInit(BTA_FltRmsFramesConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTrmsFramesClose(BTA_FltHandle *handle);
BTA_Status BFLTrmsFramesApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif